from bpy.types import Operator
from ...addon.naming import FluidLabNaming
from bpy.props import IntProperty
from ...libs.functions.get_common_vars import get_common_vars


""" Clase para extender los operadores que usan popup para reutilizar listados de Fluid Goup y/o Emitters list """


class FLUIDLAB_OT_list_reuse_base(Operator):
    bl_idname = "fluidlab.list_reuse_base"
    bl_label = "Add New Interaction"
    
    prev_group_index: IntProperty(default=-1)
    prev_emitter_index: IntProperty(default=-1)


    def invoke(self, context, event):

        # Guardo los index previos que tuviera el usuario:
        fluid_groups, ui = get_common_vars(context, get_fluid_groups=True, get_ui=True)
        active_group = fluid_groups.active

        if active_group is None:
            self.report({'ERROR'}, "No active group were detected")
            return {'CANCELLED'}
        
        emitters_list = active_group.emitters
        self.prev_group_index = fluid_groups.list_index
        self.prev_emitter_index = emitters_list.list_index

        wm = context.window_manager
        wm[FluidLabNaming.WM_POPUP_OPENED] = True
        
        # Ancho del popup (si no existe el key usa el por default):
        width_mapping = {'FLUID_INTERACTIONS': 400, 'MESH': 250}
        por_default = 200
        width = width_mapping.get(ui.main_modules, por_default)

        return context.window_manager.invoke_props_dialog(self, width=width)
    

    def cancel(self, context):
        # Restauro los index previos que tuviera el usuario:
        self.restore_indexs(context)
    

    def restore_indexs(self, context):

        """ Restauro los index previos que tuviera el usuario """

        wm = context.window_manager
        wm[FluidLabNaming.WM_POPUP_OPENED] = False
        
        fluid_groups = get_common_vars(context, get_fluid_groups=True)

        # Fluid Groups List:
        if self.prev_group_index != -1: # si tiene previo guardado
            if not fluid_groups.is_void: # si no estan vacios
                if fluid_groups.list_index != self.prev_group_index: # si son distintos valores
                    fluid_groups.list_index = self.prev_group_index

        # Geometry/Inflow Emitters List:
        active_group = fluid_groups.active
        emitters_list = active_group.emitters
        if self.prev_emitter_index != -1: # si tiene previo guardado
            if not emitters_list.is_void: # si no estan vacios
                if emitters_list.list_index != self.prev_emitter_index: # si son distintos valores
                    emitters_list.list_index = self.prev_emitter_index
        
        # Con esto hago que el redibujado sea instantaneo:
        ui_regions = [region for area in context.screen.areas if area.type == 'VIEW_3D' for space in area.spaces if space.type == 'VIEW_3D' for region in area.regions if region.type == 'UI']
        for region in ui_regions: region.tag_redraw()

        # Para indicar que se finaliza los popups de bake:
        if FluidLabNaming.WM_BAKE_POPUP_OPENED in wm:
            del wm[FluidLabNaming.WM_BAKE_POPUP_OPENED]